' VBA example for signal generators
' To run this module, register the AP_COMM_COM library and
' select "AP_COMM_COM 1.0 Type Library" at Tools -> References
'
Sub example()

' Load library (loading of VISA (GPIB) support is optional)
Dim COMM As AP_COMM_COMLib.COMM
Set COMM = New AP_COMM_COMLib.COMM
COMM.loadVisa

' Find devices
Dim devices As String
Call COMM.Find(1000, LAN Or USB Or VISA_GPIB, devices)
' Separate found devices
Dim devicesArray() As String
devicesArray = Split(devices, ";")
' Separate fields of first device
Dim firstDeviceFields() As String
firstDeviceFields = Split(devicesArray(0), ":", 3)
' Get address string of first device
Dim firstDeviceAddress As String
firstDeviceAddress = firstDeviceFields(2)
MsgBox ("Address of first device found: " + firstDeviceAddress)

' Open link
Dim link As AP_COMM_COMLib.instr
Set link = COMM.openinstr(firstDeviceAddress, 2000)

' Query "*IDN?"
link.puts ("*IDN?")
Dim ans As String
ans = link.gets
MsgBox ("*IDN? response: <" + ans + ">")

' Send sweep list
Dim list As String
list = "10e6;0.0;1.0;1.0" + vbLf _
     + "20e6;0.0;1.0;1.0" + vbLf _
     + "30e6;0.0;1.0;1.0" + vbLf _
     + "40e6;0.0;1.0;1.0" + vbLf _
     + "50e6;0.0;1.0;1.0" + vbLf
Dim listData() As Byte
listData = StrConv(list, vbFromUnicode)
Call link.writeBlock("MEM:FILE:LIST:DATA", listData)

' Query sent list's number of points
link.puts ("LIST:CURR:POIN?")
ans = link.gets
MsgBox ("Device received " + ans + " points list")

' Receive processed sweep list
listData = link.readBlock("MEM:FILE:LIST:DATA?", BlockType_UI1)
list = StrConv(listData, vbUnicode)
MsgBox ("Processed list data:" + vbLf + list)

' Close link
link.Close
Set link = Nothing
COMM.freeVisa
Set COMM = Nothing
End Sub


